/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.core.BackEnd;
import jade.core.IMTPException;
import jade.core.NotFoundException;
import jade.imtp.leap.Command;
import jade.imtp.leap.MicroSkeleton;
import jade.lang.acl.ACLMessage;
import jade.security.JADESecurityException;

public class BackEndSkel
extends MicroSkeleton {
    private BackEnd myBackEnd;

    public BackEndSkel(BackEnd be) {
        this.myBackEnd = be;
    }

    Command executeCommand(Command c) throws Throwable {
        switch (c.getCode()) {
            case 24: {
                try {
                    this.myBackEnd.messageOut((ACLMessage)c.getParamAt(0), (String)c.getParamAt(1));
                    c.reset(1);
                }
                catch (NotFoundException nfe) {
                    c = this.createErrorRsp(nfe, true);
                }
                catch (IMTPException imtpe) {
                    c = this.createErrorRsp(imtpe, true);
                }
                break;
            }
            case 20: {
                try {
                    String name = this.myBackEnd.bornAgent((String)c.getParamAt(0));
                    c.reset(1);
                    c.addParam(name);
                }
                catch (JADESecurityException ae) {
                    c = this.createErrorRsp(ae, true);
                }
                catch (IMTPException imtpe) {
                    c = this.createErrorRsp(imtpe, true);
                }
                break;
            }
            case 21: {
                try {
                    this.myBackEnd.deadAgent((String)c.getParamAt(0));
                    c.reset(1);
                }
                catch (IMTPException imtpe) {
                    c = this.createErrorRsp(imtpe, true);
                }
                break;
            }
            case 22: {
                try {
                    this.myBackEnd.suspendedAgent((String)c.getParamAt(0));
                    c.reset(1);
                }
                catch (NotFoundException nfe) {
                    c = this.createErrorRsp(nfe, true);
                }
                catch (IMTPException imtpe) {
                    c = this.createErrorRsp(imtpe, true);
                }
                break;
            }
            case 23: {
                try {
                    this.myBackEnd.resumedAgent((String)c.getParamAt(0));
                    c.reset(1);
                }
                catch (NotFoundException nfe) {
                    c = this.createErrorRsp(nfe, true);
                }
                catch (IMTPException imtpe) {
                    c = this.createErrorRsp(imtpe, true);
                }
                break;
            }
            default: {
                throw new IMTPException("Unsupported command " + c.getCode());
            }
        }
        return c;
    }
}

